<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>DSP Project</title>
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">


    <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>


    <script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>


    <script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
</head>
<body>

    <header class="header">
        <div class="hamburger" id="burger">
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
        </div>

        <div class="header-logo">
            <div class="img">
                <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('assets/img/RDC-MEDIA-Logo.png')); ?>" alt="logo"></a>
            </div>
        </div>

        <div class="user d-flex justyfy-content-between align-items-center gap-3 ms-auto">
            <div class="icon">
                <i class="fa fa-envelope" aria-hidden="true"><span class="badge text-white bg-danger">10</span></i>
            </div>

            <div class="user-img ms-1">
                <img src="<?php echo e(asset('assets/img/user-img.png')); ?>" alt="user Profile">
                <div class="mobile-dropdown">
                    <ul class="menu">
                        <li>
                           
                            <a  href="<?php echo e(route('logout')); ?>"
                        onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                        <?php echo e(__('Logout')); ?>

                        </a>

                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                            <?php echo csrf_field(); ?>
                        </form>
                        
                        
                        </li>
                        <!-- <li><a href="#">Another Action</a></li>
                        <li><a href="#">Some Else here</a></li> -->
                    </ul>
                </div>
            </div>

            <div class="dropdown">
                <a class="btn dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false"><?php echo e(Auth::user()->name); ?></a>

                <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                    <li>
                    <a  class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                        onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                        <?php echo e(__('Logout')); ?>

                        </a>

                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                            <?php echo csrf_field(); ?>
                        </form>
                </li>


                    <!-- <li><a class="dropdown-item" href="#">Another action</a></li>
                    <li><a class="dropdown-item" href="#">Something else here</a></li> -->
                </ul>
            </div>
        </div>
    </header>

    <?php echo $__env->make('layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>



    <?php if(Session::has('message')): ?>
    <script>
            var type = "<?php echo e(Session::get('alert-type', 'info')); ?>"
            switch (type) {
                case 'info':

                    toastr.options.timeOut = 2000;
                    toastr.info("<?php echo e(Session::get('message')); ?>");
                    break;
                case 'success':

                    toastr.options.timeOut = 2000;
                    toastr.success("<?php echo e(Session::get('message')); ?>");
        
                    break;
                case 'warning':

                    toastr.options.timeOut = 2000;
                    toastr.warning("<?php echo e(Session::get('message')); ?>");
        
                    break;
                case 'error':

                    toastr.options.timeOut = 2000
                    toastr.error("<?php echo e(Session::get('message')); ?>");
                    break;
            }
      
    </script>

  <?php endif; ?>

<script>
        // document.getElementById("confirmDelete").addEventListener("click", function() {
        //     $('#frm_confirmDelete').submit();
        // });
</script>



    
</body>

</html><?php /**PATH C:\xampp\htdocs\UploadDSP_LARAVEL\resources\views/layouts/app.blade.php ENDPATH**/ ?>